<?php if(current_customer() && !system_setting('bought_review')): ?>
  <form action="<?php echo e(account_route('reviews.store')); ?>" method="post">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
    <div>
      <div class="review-content">
        <div class="row">
          <label class="col-8 text-left font-size-25 mb-0" for="review">
            <h5><?php echo e(__('front/product.input_your_review')); ?></h5>
          </label>

          <div class="rating col-4 text-end">
            <input type="radio" name="rating" value="5" id="5">
            <label for="5">☆</label>
            <input type="radio" name="rating" value="4" id="4">
            <label for="4">☆</label>
            <input type="radio" name="rating" value="3" id="3" checked>
            <label for="3">☆</label>
            <input type="radio" name="rating" value="2" id="2">
            <label for="2">☆</label>
            <input type="radio" name="rating" value="1" id="1">
            <label for="1">☆</label>
          </div>
        </div>

        <textarea class="form-control" name="content" id="review" rows="5"
                  placeholder="<?php echo e(__('front/product.input_some_text_here')); ?>..."></textarea>
      </div>
    </div>
    <div class="col-12 text-end mt-3">
      <button class="btn btn-primary submit_review"><?php echo e(__('front/product.submit_review')); ?></button>
    </div>
  </form>
<?php else: ?>
  <div class="m-5 text-center">
    <?php if(!current_customer()): ?>
      <a class="btn btn-primary" href="javascript:inno.openLogin()"><?php echo e(__('front/product.please_login_first')); ?></a>
    <?php else: ?>
      <a class="btn btn-primary" href="<?php echo e(account_route('orders.index')); ?>" target="_blank"><?php echo e(__('front/product.visit_order_to_review')); ?></a>
    <?php endif; ?>
  </div>
<?php endif; ?>

<?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <br/>
  <hr/>
  <div class="review-list row">
    <div class="row">
      <h5 class="col-2 mb-3"><?php echo e($review['customer_name']); ?></h5>
      <span class="col-4 text-left"><?php if (isset($component)) { $__componentOriginald225e61f839b80f54d6d93b6c98f376c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald225e61f839b80f54d6d93b6c98f376c = $attributes; } ?>
<?php $component = InnoShop\Front\Components\Review::resolve(['rating' => $review['rating']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('front-review'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\InnoShop\Front\Components\Review::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald225e61f839b80f54d6d93b6c98f376c)): ?>
<?php $attributes = $__attributesOriginald225e61f839b80f54d6d93b6c98f376c; ?>
<?php unset($__attributesOriginald225e61f839b80f54d6d93b6c98f376c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald225e61f839b80f54d6d93b6c98f376c)): ?>
<?php $component = $__componentOriginald225e61f839b80f54d6d93b6c98f376c; ?>
<?php unset($__componentOriginald225e61f839b80f54d6d93b6c98f376c); ?>
<?php endif; ?></span>
      <span class="col-6 text-end date"><?php echo e($review['created_at']); ?></span>
    </div>
    <p class="mb-3"><?php echo e($review['content']); ?></p>
  </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php /**PATH C:\wamp64\www\inno\innopacks\front\resources\views/products/review.blade.php ENDPATH**/ ?>