<div class="card variants-box mb-3" id="variants-box">
  <div class="card-header">
    <h5 class="card-title mb-0"><?php echo e(__('panel/attribute.attribute')); ?></h5>
  </div>
  <div id="hide-attribute" class="card-body <?php echo e($attribute_count ? '' : 'd-none'); ?>">
    <table id="attributeTable" class="table table-condensed table-bordered">
      <tr>
        <td><?php echo e(__('panel/attribute.attribute')); ?></td>
        <td><?php echo e(__('panel/attribute.attribute_value')); ?></td>
        <td class="text-center align-middle">
          <a id="add-attribute" class="button btn-primary" href="javascript:void(0)">
            <i class="bi-plus-lg"></i>
          </a>
        </td>
      </tr>

      <?php if($product->productAttributes->count()): ?>
        <?php $__currentLoopData = $product->productAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td class="col-5">
              <select class="form-control attribute-id" name="attributes[<?php echo e($index); ?>][attribute_id]">
                <?php $__currentLoopData = $all_attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option
                      value="<?php echo e($item['id']); ?>" <?php echo e($attr->attribute_id == $item['id'] ? 'selected' : ''); ?>><?php echo e($item['name']); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </td>
            <td class="col-5">
              <select class="form-control attribute-value-id" name="attributes[<?php echo e($index); ?>][attribute_value_id]"
                      data-attr-value-id="<?php echo e($attr->attribute_value_id); ?>">
                <?php $__currentLoopData = $all_attribute_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option
                      value="<?php echo e($item['id']); ?>" <?php echo e($attr->attribute_value_id == $item['id'] ? 'selected' : ''); ?>><?php echo e($item['name']); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </td>
            <td class="col-2 text-center align-middle "><a type="button" class="btn-lg del-attr"><i
                    class="bi-trash"></i></a></td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php else: ?>
        <tr>
          <td class="col-5">
            <select class="form-control attribute-id" name="attributes[0][attribute_id]">
              <?php $__currentLoopData = $all_attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($item['id']); ?>"><?php echo e($item['name']); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </td>
          <td class="col-5">
            <select class="form-control attribute-value-id" name="attributes[0][attribute_value_id]"></select>
          </td>
          <td class="col-2 text-center align-middle "><a type="button" class="btn-lg del-attr"><i
                  class="bi-trash"></i></a></td>
        </tr>
      <?php endif; ?>

    </table>
  </div>

  <div class="cursor-pointer m-3 text-primary <?php echo e($attribute_count ? 'd-none' : 'd-inline-block'); ?>" id="new-attribute">
    <i class="bi bi-plus-square me-1"></i> <?php echo e(__('panel/attribute.set_attribute')); ?>

  </div>
</div>

<?php $__env->startPush('footer'); ?>
  <script>
    $('#new-attribute').click(function () {
      $(this).addClass('d-none');
      $('#hide-attribute').removeClass('d-none');
    });
    $('#delete-all-attribute').click(function () {
      $('#hide-attribute').addClass('d-none');
    });

    let lineNo = <?php echo e($attribute_count); ?>;
    $(document).ready(function () {
      $('.attribute-id').trigger('change');
      $('#add-attribute').click(function () {
        let markup = '<tr>\
         <td class="col-5"><select class="form-control attribute-id" name="attributes[' + lineNo + '][attribute_id]"></select></td>\
         <td class="col-5"><select class="form-control attribute-value-id" name="attributes[' + lineNo + '][attribute_value_id]"></select></td>\
         <td class="col-2 text-center align-middle "><a type="button" class="btn-lg del-attr"><i class="bi-trash"></i></a></td>\
       </tr>';
        let tableBody = $("table tbody");
        tableBody.append(markup);

        let eleObj = $('select[name="attributes[' + lineNo + '][attribute_id]"]')
        setAttribute(eleObj);
        lineNo++;
      });
    });

    $(document).on('click', '.del-attr', function () {
      $(this).parent().parent().remove();
    });

    $(document).on('change', '.attribute-id', function () {
      let attributeEle = $(this);
      let attributeID = attributeEle.val();
      let attributeValueEle = attributeEle.parent().next().find('select');
      $.ajax({
        url: '<?php echo e(route('api.panel.attribute_values.index')); ?>',
        type: 'GET',
        data: {
          locale: '<?php echo e(panel_locale_code()); ?>',
          attribute_id: attributeID
        },
        success: function (response) {
          let options = '';
          $.each(response.data, function (index, value) {
            options += '<option value="' + value.id + '">' + value.name + '</option>';
          });
          attributeValueEle.html(options);

          let currentValueID = attributeValueEle.data('attr-value-id');
          if (currentValueID) {
            attributeValueEle.val(currentValueID);
          }
        }
      });
    });

    function setAttribute(eleObj) {
      $.ajax({
        url: '<?php echo e(route('api.panel.attributes.index')); ?>',
        type: 'GET',
        data: {
          locale: '<?php echo e(panel_locale_code()); ?>',
        },
        success: function (response) {
          let options = '';
          $.each(response.data, function (index, value) {
            options += '<option value="' + value.id + '">' + value.name + '</option>';
          });
          eleObj.html(options);
          eleObj.trigger('change');
        },
        error: function (error) {
          console.log('Error:', error);
        }
      });
    }
  </script>
<?php $__env->stopPush(); ?><?php /**PATH C:\wamp64\www\inno\innopacks/panel/resources/views/products/_form_attribute.blade.php ENDPATH**/ ?>