<?php if($criteria): ?>
  <form action="<?php echo e($action); ?>" method="GET" class="mb-4">
    <div class="row">
      <div class="row col-md-12 <?php echo e(has_set_value(request()->all()) ? 'collapse show' : 'collapse'); ?>"
           id="collapse-filters">

        <?php $__currentLoopData = $criteria; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php if($item['type'] == 'input'): ?>
            <div class="col-md-3 col-sm-6 mb-3">
              <label for="<?php echo e($item['name']); ?>" class="form-label form-label-sm"><?php echo e($item['label']); ?></label>
              <input type="text" name="<?php echo e($item['name']); ?>" id="<?php echo e($item['name']); ?>"
                     class="form-control form-control-sm"
                     value="<?php echo e(request($item['name'])); ?>"
                     placeholder="<?php echo e($item['label']); ?>">
            </div>
          <?php elseif($item['type'] == 'select'): ?>
            <div class="col-md-3 col-sm-6 mb-3">
              <label for="<?php echo e($item['name']); ?>" class="form-label form-label-sm"><?php echo e($item['label']); ?></label>
              <select name="<?php echo e($item['name']); ?>" id="<?php echo e($item['name']); ?>" class="form-select form-select-sm">
                <option value=""><?php echo e(panel_trans('common.please_choose')); ?></option>
                <?php $__currentLoopData = $item['options']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option
                      value="<?php echo e(isset($item['options_key']) ? $option[$item['options_key']] : $option['value']); ?>" <?php echo e(request($item['name'])==(isset($item['options_key']) ? $option[$item['options_key']] : $option['value']) ? 'selected' : ''); ?>><?php echo e(isset($option['label_key']) ? trans($option['label_key']) : (isset($item['options_label']) ? $option[$item['options_label']] : $option['label'])); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          <?php elseif($item['type'] == 'date'): ?>
            <div class="col-md-3 col-sm-6 mb-3">
              <label for="<?php echo e($item['name']); ?>" class="form-label form-label-sm"><?php echo e($item['label']); ?></label>
              <input type="date" name="<?php echo e($item['name']); ?>" id="<?php echo e($item['name']); ?>"
                     class="form-control form-control-sm"
                     value="<?php echo e(request($item['name'])); ?>"
                     placeholder="<?php echo e($item['label']); ?>">
            </div>
          <?php elseif($item['type'] == 'range'): ?>
            <div class="col-md-3 col-sm-6 mb-3">
              <label class="form-label form-label-sm"><?php echo e($item['label']); ?></label>
              <div class="input-group input-group-sm">
                <input type="text" name="<?php echo e($item['start']['name']); ?>" class="form-control"
                       value="<?php echo e(request($item['start']['name'])); ?>"
                       placeholder="<?php echo e($item['start']['label'] ?? ''); ?>">
                <span class="input-group-text">-</span>
                <input type="text" name="<?php echo e($item['end']['name']); ?>" class="form-control"
                       value="<?php echo e(request($item['end']['name'])); ?>"
                       placeholder="<?php echo e($item['end']['label'] ?? ''); ?>">
              </div>
            </div>
          <?php elseif($item['type'] == 'date_range'): ?>
            <div class="col-md-3 col-sm-6 mb-3">
              <label class="form-label form-label-sm"><?php echo e($item['label']); ?></label>
              <div class="input-group input-group-sm">
                <input type="date" name="<?php echo e($item['start']['name']); ?>" class="form-control"
                       value="<?php echo e(request($item['start']['name'])); ?>"
                       placeholder="<?php echo e($item['start']['label'] ?? ''); ?>">
                <span class="input-group-text">-</span>
                <input type="date" name="<?php echo e($item['end']['name']); ?>" class="form-control"
                       value="<?php echo e(request($item['end']['name'])); ?>"
                       placeholder="<?php echo e($item['end']['label'] ?? ''); ?>">
              </div>
            </div>
          <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      </div>
    </div>

    <div class="row mt-3">
      <div class="col-6">
        <button type="submit" class="btn btn-primary btn-sm"><i class="bi bi-search"></i>
          <?php echo e(__('panel/common.filter')); ?></button>
        <a href="<?php echo e($action); ?>" class=" btn btn-sm btn-outline-primary" style="margin-left: 5px">
          <i class="bi bi-arrow-clockwise"></i> <?php echo e(__('panel/common.reset')); ?>

        </a>
      </div>
      <div class="col-6 row justify-content-end">
        <div class="col-auto">
          <button id="collapse-button" type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="collapse"
                  data-bs-target="#collapse-filters" aria-expanded="false" aria-controls="collapse-filters">
          <span class="down">
            <i class="bi bi-arrow-down"></i><?php echo e(__('panel/common.expand')); ?>

          </span>
            <span class="up">
            <i class="bi bi-arrow-up"></i><?php echo e(__('panel/common.collapse')); ?>

          </span>
          </button>
        </div>
      </div>
    </div>

  </form>

  <?php $__env->startPush('footer'); ?>
    <script>
      let filterEl = $('#collapse-filters');
      let showEl = $('#collapse-button .down');
      let hideEl = $('#collapse-button .up');

      filterEl.on('show.bs.collapse', function () {
        showEl.hide();
        hideEl.show();
      });

      filterEl.on('hide.bs.collapse', function () {
        showEl.show();
        hideEl.hide();
      });

      if (filterEl.hasClass('show')) {
        showEl.hide();
        hideEl.show();
      } else {
        showEl.show();
        hideEl.hide();
      }
    </script>
  <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH C:\wamp64\www\inno\innopacks/panel/resources/views/components/criteria.blade.php ENDPATH**/ ?>