<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(panel_locale_direction()); ?>">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <base href="<?php echo e(panel_route('home.index')); ?>">
  <title><?php echo $__env->yieldContent('title', ''); ?> - InnoShop</title>
  <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', 'InnoShop, 创新, 开源, CMS, Laravel 11, 多语言, 多货币, Hook, 插件架构, 灵活, 强大'); ?>">
  <meta name="generator" content="InnoShop <?php echo e(innoshop_version()); ?>">
  <meta name="asset" content="<?php echo e(asset('/')); ?>">
  <meta name="description" content="<?php echo $__env->yieldContent('description', 'InnoShop'); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="api-token" content="<?php echo e(session('api_token')); ?>">
  <link rel="shortcut icon" href="<?php echo e(image_origin(system_setting('favicon', 'images/favicon.png'))); ?>">

  <!-- 基础样式和脚本 -->
  <link rel="stylesheet" href="<?php echo e(mix('build/panel/css/bootstrap.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(mix('build/panel/css/app.css')); ?>">
  <script src="<?php echo e(asset('vendor/jquery/jquery-3.7.1.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset('vendor/layer/3.5.1/layer.js')); ?>"></script>
  <script src="<?php echo e(mix('build/panel/js/app.js')); ?>"></script>
  <script>
    let urls = {
      base_url: '<?php echo e(panel_route('home.index')); ?>',
      upload_images: '<?php echo e(panel_route('upload.images')); ?>',
      ai_generate: '<?php echo e(panel_route('content_ai.generate')); ?>',
    }

    const lang = {
      hint: '<?php echo e(__('panel/common.hint')); ?>',
      delete_confirm: '<?php echo e(__('panel/common.delete_confirm')); ?>',
      confirm: '<?php echo e(__('panel/common.confirm')); ?>',
      cancel: '<?php echo e(__('panel/common.cancel')); ?>',
    }
  </script>
  <?php echo $__env->yieldPushContent('header'); ?>
</head>

<body class="<?php echo $__env->yieldContent('body-class'); ?>">
  <div class="container-fluid">
    <?php echo $__env->yieldContent('content'); ?>
      <div class="page-bottom-btns my-4">
          <?php echo $__env->yieldContent('page-bottom-btns'); ?>
      </div>
  </div>
  <?php echo $__env->yieldPushContent('footer'); ?>
</body>

</html>
<?php /**PATH C:\wamp64\www\inno\innopacks/panel/resources/views/layouts/blank.blade.php ENDPATH**/ ?>