<?php $__env->startSection('body-class', 'page-home'); ?>

<?php $__env->startSection('title', __('panel/menu.dashboard')); ?>

<?php $__env->startPush('header'); ?>
<script src="<?php echo e(asset('vendor/chart/chart.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div class="row dashboard-top-card g-2 g-lg-4 mb-3 mb-lg-4">
  <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <div class="col-6 col-md-3">
    <div class="card dashboard-item">
      <div class="card-body">
        <a href="<?php echo e($card['url']); ?>" class="text-decoration-none">
        <div class="d-flex justify-content-between align-items-center">
          <div class="left">
            <div class="quantity text-dark"><?php echo e($card['quantity']); ?></div>
            <span class="title text-secondary"><?php echo e($card['title']); ?></span>
          </div>
          <div class="right"><i class="<?php echo e($card['icon']); ?> icon"></i></div>
        </div>
        </a>
      </div>
    </div>
  </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<div class="row">
  <div class="col-12 col-md-6 mb-3">
    <div class="card">
      <div class="card-header"><?php echo e(__('panel/dashboard.order_trends')); ?></div>
      <div class="card-body">
        <canvas id="chart-new-quantity"></canvas>
      </div>
    </div>
  </div>
  <div class="col-12 col-md-6 mb-3">
    <div class="card top-sale-products">
      <div class="card-header"><?php echo e(__('panel/dashboard.top_products')); ?></div>
      <div class="card-body pb-0">
        <?php if($top_sale_products): ?>
          <table class="table table-last-no-border align-middle mt-n3 mb-0">
            <tbody>
              <?php $__currentLoopData = $top_sale_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td class="text-center">
                  <?php if($loop->iteration <= 3): ?>
                    <img src="<?php echo e(asset('icon/grade-'. $loop->iteration .'.svg')); ?>" alt="<?php echo e($product['name']); ?>" class="img-fluid wh-30">
                  <?php else: ?>
                    <span class="badge bg-secondary"><?php echo e($loop->iteration); ?></span>
                  <?php endif; ?>
                </td>
                <td>
                  <a class="d-flex align-items-center text-dark text-decoration-none" href="<?php echo e(panel_route('products.edit', $product['product_id'])); ?>">
                    <div class="wh-30 rounded-circle overflow-hidden border border-1 me-2"><img src="<?php echo e($product['image']); ?>" alt="<?php echo e($product['name']); ?>" class="img-fluid"></div>
                    <?php echo e($product['summary']); ?>

                  </a>
                </td>
                <td class="text-center"><?php echo e($product['order_count']); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        <?php else: ?>
          <?php if (isset($component)) { $__componentOriginal295d9e45e90747fdb30f4db07eae728c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal295d9e45e90747fdb30f4db07eae728c = $attributes; } ?>
<?php $component = InnoShop\Common\Components\NoData::resolve(['width' => 240] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('common-no-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\InnoShop\Common\Components\NoData::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal295d9e45e90747fdb30f4db07eae728c)): ?>
<?php $attributes = $__attributesOriginal295d9e45e90747fdb30f4db07eae728c; ?>
<?php unset($__attributesOriginal295d9e45e90747fdb30f4db07eae728c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal295d9e45e90747fdb30f4db07eae728c)): ?>
<?php $component = $__componentOriginal295d9e45e90747fdb30f4db07eae728c; ?>
<?php unset($__componentOriginal295d9e45e90747fdb30f4db07eae728c); ?>
<?php endif; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<img src="<?php echo e(dashboard_url()); ?>" class="d-none" alt="dashboard"/>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer'); ?>
<script>
  const ctx1 = document.getElementById('chart-new-quantity').getContext('2d');
  const options = {
    responsive: true,
    maintainAspectRatio: false,
    plugins: {
      legend: false
    },
    interaction: {
      mode: 'index',
      intersect: false,
    },
    scales: {
      y: {
        beginAtZero: true,
        grid: {
          drawBorder: false,
          borderDash: [3],
        },
      },
      x: {
        beginAtZero: true,
        grid: {
          drawBorder: false,
          display: false
        },
      }
    },
  };

  const orderGradient = ctx1.createLinearGradient(0, 0, 0, 380);
  orderGradient.addColorStop(0, 'rgba(76,122,247,0.5)');
  orderGradient.addColorStop(1, 'rgba(76,122,247,0)');

  const chart1 = new Chart(ctx1, {
    type: 'line',
    data: {
      labels: <?php echo json_encode($order['latest_week']['period'], 15, 512) ?>,
      datasets: [{
        label: '<?php echo e(__('panel/dashboard.order_quantity')); ?>',
        data: <?php echo json_encode($order['latest_week']['totals'], 15, 512) ?>,
        responsive: true,
        backgroundColor : orderGradient,
        borderColor : "#3c7af7",
        fill: true,
        lineTension: 0.4,
        datasetStrokeWidth: 3,
        pointBackgroundColor: '#3c7af7',
        pointDotStrokeWidth: 4,
        pointHoverBorderWidth: 8,
        tension: 0.1
      }]
    },
    options: options
  });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('panel::layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\inno\innopacks/panel/resources/views/dashboard.blade.php ENDPATH**/ ?>