<?php $__env->startSection('body-class', 'page-category'); ?>

<?php $__env->startSection('title', __('panel/menu.categories')); ?>

<?php $__env->startSection('page-title-right'); ?>
  <a href="<?php echo e(panel_route('categories.create')); ?>" class="btn btn-primary"><i
        class="bi bi-plus-square"></i> <?php echo e(__('panel/common.create')); ?></a>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="card h-min-600">
    <div class="card-body">
      <?php if(count($categories)): ?>
        <div class="accordion" id="categories-top"></div>
      <?php else: ?>
        <?php if (isset($component)) { $__componentOriginal295d9e45e90747fdb30f4db07eae728c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal295d9e45e90747fdb30f4db07eae728c = $attributes; } ?>
<?php $component = InnoShop\Common\Components\NoData::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('common-no-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\InnoShop\Common\Components\NoData::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal295d9e45e90747fdb30f4db07eae728c)): ?>
<?php $attributes = $__attributesOriginal295d9e45e90747fdb30f4db07eae728c; ?>
<?php unset($__attributesOriginal295d9e45e90747fdb30f4db07eae728c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal295d9e45e90747fdb30f4db07eae728c)): ?>
<?php $component = $__componentOriginal295d9e45e90747fdb30f4db07eae728c; ?>
<?php unset($__componentOriginal295d9e45e90747fdb30f4db07eae728c); ?>
<?php endif; ?>
      <?php endif; ?>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer'); ?>
<script>
  const api = <?php echo json_encode(panel_route('categories.index'), 15, 512) ?>;
  const categories = <?php echo json_encode($categories, 15, 512) ?>;
  const categoryIndexUrl = <?php echo json_encode(panel_route('categories.index'), 15, 512) ?>;

  function createAccordionItem(item, parentId, index) {
    const itemId = `${parentId}-${index}`;
    const collapseId = `collapse${itemId}`;
    const hasChildren = item.children && item.children.length > 0;

    let html = `
      <div class="accordion-item">
        <h2 class="accordion-header" id="heading${itemId}">
          <div class="d-flex justify-content-between align-items-center">
            <button class="accordion-button collapsed ${!hasChildren ? 'no-children' : ''}" type="button" ${hasChildren ? `data-bs-toggle="collapse" data-bs-target="#${collapseId}" aria-expanded="false" aria-controls="${collapseId}"` : ''}>
              <span>${item.name}</span>
            </button>
            <div class="d-flex align-items-center tool-btn" data-id="${item.id}">
              <div class="form-check form-switch list-switch ms-2">
                <input class="form-check-input" type="checkbox" role="switch" ${item.active ? 'checked' : ''}>
              </div>
              <a href="${categoryIndexUrl}/${item.id}/edit" class="btn btn-sm text-nowrap edit-category btn-outline-primary ms-3"><?php echo e(__('panel/common.edit')); ?></a>
              <span class="btn btn-sm ms-2 text-nowrap btn-outline-danger btn-delete"><?php echo e(__('panel/common.delete')); ?></span>
            </div>
          </div>
        </h2>`;

    if (hasChildren) {
      html += `
        <div id="${collapseId}" class="accordion-collapse collapse" aria-labelledby="heading${itemId}" data-bs-parent="#${parentId}">
          <div class="accordion-body">
            <div class="accordion" id="accordion${itemId}">`;

      item.children.forEach((child, i) => {
        html += createAccordionItem(child, `accordion${itemId}`, i);
      });

      html += `</div></div></div>`;
    }

    html += `</div>`;
    return html;
  }

  function renderAccordion(data, parentId) {
    let html = '';
    data.forEach((item, index) => {
      html += createAccordionItem(item, parentId, index);
    });
    $(`#${parentId}`).html(html);
  }

  $(document).ready(function() {
    renderAccordion(categories, 'categories-top');
  });

  $(document).on('change', '.form-check-input', function() {
    const id = $(this).closest('.d-flex').data('id');
    const status = $(this).prop('checked');

    layer.load(2, {shade: [0.3,'#fff'] })
    axios.put(`${api}/${id}/active`, {status}).then((res) => {
      inno.msg(res.message)
    }).catch((err) => {
      $(this).prop('checked', !status);
      inno.msg(err.response.data.message)
    }).finally(() => {
      layer.closeAll('loading');
    });
  });


  $(document).on('click', '.btn-delete', function() {
    const id = $(this).closest('.tool-btn').data('id');
    inno.confirmDelete(`${api}/${id}`)
  });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('panel::layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\wamp64\www\inno\innopacks/panel/resources/views/categories/index.blade.php ENDPATH**/ ?>