<?php
/**
 * Copyright (c) Since 2024 InnoShop - All Rights Reserved
 *
 * @link       https://www.innoshop.com
 * @author     InnoShop <team@innoshop.com>
 * @license    https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 */

return [
    'accepted'        => 'Devi accettare :attribute.',
    'accepted_if'     => 'Devi accettare :attribute se :other è :value.',
    'active_url'      => ':attribute non è un URL valido.',
    'after'           => ':attribute deve essere successiva a :date.',
    'after_or_equal'  => ':attribute deve essere successiva o uguale a :date.',
    'alpha'           => ':attribute può contenere solo lettere.',
    'alpha_dash'      => ':attribute può contenere solo lettere, numeri, trattini e underscores.',
    'alpha_num'       => ':attribute può contenere solo lettere e numeri.',
    'array'           => ':attribute deve essere un array.',
    'before'          => ':attribute deve essere precedente a :date.',
    'before_or_equal' => ':attribute deve essere precedente o uguale a :date.',
    'between'         => [
        'array'   => ':attribute deve avere tra :min - :max elementi.',
        'file'    => ':attribute deve essere tra :min - :max KB.',
        'numeric' => ':attribute deve essere tra :min - :max.',
        'string'  => ':attribute deve avere tra :min - :max caratteri.',
    ],
    'boolean'          => ':attribute deve essere un valore booleano.',
    'confirmed'        => 'Il campo di conferma di :attribute non coincide.',
    'current_password' => 'La password è errata.',
    'date'             => ':attribute non è una data valida.',
    'date_equals'      => ':attribute deve essere uguale a :date.',
    'date_format'      => ':attribute non corrisponde al formato :format.',
    'declined'         => ':attribute deve essere rifiutato.',
    'declined_if'      => 'Il campo :attribute deve essere rifiutato se :other è :value.',
    'different'        => ':attribute e :other devono essere differenti.',
    'digits'           => ':attribute deve essere组成 :digits cifre.',
    'digits_between'   => ':attribute deve essere tra :min e :max cifre.',
    'dimensions'       => 'Le dimensioni dell\'immagine di :attribute non sono valide.',
    'distinct'         => ':attribute already exists.',
    'email'            => ':attribute non è un indirizzo email valido.',
    'ends_with'        => ':attribute must end with one of the following: :values.',
    'enum'             => 'The selected :attribute is invalid.',
    'exists'           => ':attribute non esiste.',
    'file'             => ':attribute deve essere un file.',
    'filled'           => ':attribute non può essere vuoto.',
    'gt'               => [
        'array'   => ':attribute must have more than :value items.',
        'file'    => ':attribute must be greater than :value KB.',
        'numeric' => ':attribute must be greater than :value.',
        'string'  => ':attribute must be greater than :value characters.',
    ],
    'gte' => [
        'array'   => ':attribute must have :value items or more.',
        'file'    => ':attribute must be greater than or equal to :value KB.',
        'numeric' => ':attribute must be greater than or equal to :value.',
        'string'  => ':attribute must be greater than or equal to :value characters.',
    ],
    'image'    => ':attribute deve essere un\'immagine.',
    'in'       => 'Il valore selezionato per :attribute non è valido.',
    'in_array' => ':attribute non esiste in :other.',
    'integer'  => ':attribute deve essere un numero intero.',
    'ip'       => ':attribute deve essere un indirizzo IP valido.',
    'ipv4'     => ':attribute deve essere un indirizzo IPv4 valido.',
    'ipv6'     => ':attribute deve essere un indirizzo IPv6 valido.',
    'json'     => ':attribute deve essere un JSON valido.',
    'lt'       => [
        'array'   => ':attribute must have less than :value items.',
        'file'    => ':attribute must be less than :value KB.',
        'numeric' => ':attribute must be less than :value.',
        'string'  => ':attribute must be less than :value characters.',
    ],
    'lte' => [
        'array'   => ':attribute must not have more than :value items.',
        'file'    => ':attribute must be less than or equal to :value KB.',
        'numeric' => ':attribute must be less than or equal to :value.',
        'string'  => ':attribute must not be greater than :value characters.',
    ],
    'mac_address' => ':attribute must be a valid MAC address.',
    'max'         => [
        'array'   => ':attribute cannot have more than :max items.',
        'file'    => ':attribute cannot be greater than :max KB.',
        'numeric' => ':attribute cannot be greater than :max.',
        'string'  => ':attribute cannot be greater than :max characters.',
    ],
    'mimes'     => ':attribute must be a file of type :values.',
    'mimetypes' => ':attribute must be a file of type :values.',
    'min'       => [
        'array'   => ':attribute must have at least :min items.',
        'file'    => ':attribute must be at least :min KB.',
        'numeric' => ':attribute must be at least :min.',
        'string'  => ':attribute must be at least :min characters.',
    ],
    'multiple_of'          => ':attribute must be a multiple of :value.',
    'not_in'               => 'Il valore selezionato per :attribute non è valido.',
    'not_regex'            => ':attribute ha un formato non valido.',
    'numeric'              => ':attribute deve essere un numero.',
    'password'             => 'La password è errata',
    'present'              => ':attribute deve essere presente.',
    'prohibited'           => 'Il campo :attribute è proibito.',
    'prohibited_if'        => 'Il campo :attribute è proibito se :other è :value.',
    'prohibited_unless'    => 'Il campo :attribute è proibito a meno che :other non sia in :values.',
    'prohibits'            => 'Il campo :attribute proibisce :other.',
    'regex'                => ':attribute ha un formato non valido.',
    'required'             => ':attribute non può essere vuoto.',
    'required_array_keys'  => ':attribute must contain the keys: :values.',
    'required_if'          => 'Il campo :attribute è richiesto se :other è :value.',
    'required_unless'      => 'Il campo :attributeè richiesto a meno che :other non sia tra :values.',
    'required_with'        => 'Il campo :attribute è richiesto quando :values è presente.',
    'required_with_all'    => 'Il campo :attribute è richiesto quando :values sono presenti.',
    'required_without'     => 'Il campo :attribute è richiesto quando :values non è presente.',
    'required_without_all' => 'Il campo :attribute è richiesto quando nessuno dei :values è presente.',
    'same'                 => ':attribute e :other devono coincidere.',
    'size'                 => [
        'array'   => ':attribute must contain :size items.',
        'file'    => ':attribute must be :size KB.',
        'numeric' => ':attribute must be :size.',
        'string'  => ':attribute must be :size characters.',
    ],
    'starts_with' => ':attribute must start with one of the following: :values.',
    'string'      => ':attribute must be a string.',
    'timezone'    => ':attribute must be a valid zone.',
    'unique'      => ':attribute already exists.',
    'uploaded'    => ':attribute failed to upload.',
    'url'         => ':attribute format is invalid.',
    'uuid'        => ':attribute must be a valid UUID.',
    'custom'      => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
];
